require( "scripts/style.lua" );
deltaX =200;
deltaY = 110;
stepY = 80;

MakeDialog
{
    name="endless_diff",
    Bitmap
    {
        image="backgrounds/options",
        x=kCenter,
        y=kCenter,
        
        SetStyle(MenuButtonStyle),
        Button
        {
            name="btnEasy",
            x=deltaX,
            y=deltaY + stepY * 0,
            label="easy_btn",
            command=
                function()
                    SetCurrentGameMode(1);
                    CPP_LoadGO();
                    gEndlessDifficulty = 1;
                    LoadSelectedDiffLevel(gCurFarmBegin);
                end
        };
        Button
        {
            name="btnMedium",
            x=deltaX,
            y=deltaY + stepY * 1,
            label="medium_btn",
            command=
                function()
                    SetCurrentGameMode(2);
                    CPP_LoadGO();
                    gEndlessDifficulty = 2;
                    LoadSelectedDiffLevel(gCurFarmBegin + 1);
                end         
        };
        Button
        {
            name="btnHard",
            x=deltaX,
            y=deltaY + stepY * 2,
            label="hard_btn",
            command=
                function()
                    SetCurrentGameMode(3);
                    CPP_LoadGO();
                    gEndlessDifficulty = 3;
                    LoadSelectedDiffLevel(gCurFarmBegin + 2);
                end         
        };
        
        Button
        {
            name="btnBack",
            x=deltaX,
            y=deltaY + stepY * 3,
            label="back",
            close = true,
            command=
                function()
                    if SetMapEnabled then SetMapEnabled(true); end;
                end         
            
            
        };        
    };
};        



function LoadSelectedDiffLevel(current)

    PopModal("endless_diff");

    LevelForLoading = current;                
    gGlobalPlayerInfo.gLevelNum = LevelForLoading;
    if(LoadLevel)then
        CloseWindow("");
        LoadLevel(LevelForLoading);
    else
        PopModal("game_map_endless");
        SwapToModal("scripts/game.lua");
    end

end

